/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.containers;

import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.containers.ModContainers;
import com.direwolf20.mininggadgets.common.containers.ModificationTableCommands;
import com.direwolf20.mininggadgets.common.containers.WatchedSlot;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ModificationTableContainer
extends AbstractContainerMenu {
    private BlockEntity tileEntity;
    private IItemHandler playerInventory;
    private List<Upgrade> upgradesCache = new ArrayList<Upgrade>();

    public ModificationTableContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        super((MenuType)ModContainers.MODIFICATIONTABLE_CONTAINER.get(), windowId);
        this.tileEntity = Minecraft.m_91087_().f_91073_.m_7702_(extraData.m_130135_());
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.setupContainerSlots();
        this.layoutPlayerInventorySlots(8, 84);
    }

    public ModificationTableContainer(int windowId, Level world, BlockPos pos, Inventory playerInventory) {
        super((MenuType)ModContainers.MODIFICATIONTABLE_CONTAINER.get(), windowId);
        this.tileEntity = world.m_7702_(pos);
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.setupContainerSlots();
        this.layoutPlayerInventorySlots(10, 70);
    }

    public boolean m_6875_(Player playerIn) {
        return ModificationTableContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.getTE().m_58904_(), (BlockPos)this.tileEntity.m_58899_()), (Player)playerIn, (Block)((Block)ModBlocks.MODIFICATION_TABLE.get()));
    }

    private void setupContainerSlots() {
        this.getTE().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> this.m_38897_((Slot)new WatchedSlot((IItemHandler)h, 0, -16, 84, this::updateUpgradeCache)));
    }

    private void updateUpgradeCache(int index) {
        ItemStack stack = this.m_38853_(index).m_7993_();
        if (stack.m_41619_() && !this.upgradesCache.isEmpty() || !(stack.m_41720_() instanceof MiningGadget)) {
            this.upgradesCache.clear();
            return;
        }
        this.upgradesCache.clear();
        this.upgradesCache = UpgradeTools.getUpgrades(stack);
    }

    public List<Upgrade> getUpgradesCache() {
        return this.upgradesCache;
    }

    public BlockEntity getTE() {
        return this.tileEntity;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) return itemstack;
        ItemStack stack = slot.m_7993_();
        itemstack = stack.m_41777_();
        if (index == 0) {
            if (!this.m_38903_(stack, 1, this.m_38927_().size(), true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stack, itemstack);
        } else if (stack.m_41720_() instanceof MiningGadget) {
            if (!this.m_38903_(stack, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
        } else if (stack.m_41720_() instanceof UpgradeCard) {
            if (!ModificationTableCommands.insertButton(this, stack)) return ItemStack.f_41583_;
            int maxSize = Math.min(slot.m_6641_(), stack.m_41741_());
            int remove = maxSize - itemstack.m_41613_();
            stack.m_41774_(remove == 0 ? 1 : remove);
            this.updateUpgradeCache(0);
        } else if (index < 29 ? !this.m_38903_(stack, 29, 37, false) : index < 38 && !this.m_38903_(stack, 1, 29, false)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == itemstack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(playerIn, stack);
        return itemstack;
    }
}

